/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.command.client;

import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import org.quiltmc.qsl.command.api.client.ClientCommandRegistrationCallback;
import org.quiltmc.qsl.command.api.client.QuiltClientCommandSource;
import org.quiltmc.qsl.command.mixin.HelpCommandAccessor;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class ClientCommandInternals
implements ClientCommandRegistrationCallback {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String API_COMMAND_NAME = "fabric-command-api-v1:client";
    private static final String SHORT_API_COMMAND_NAME = "fcc";

    private static int executeRootHelp(CommandContext<FabricClientCommandSource> context) {
        return ClientCommandInternals.executeHelp((CommandNode<FabricClientCommandSource>)ClientCommandManager.DISPATCHER.getRoot(), context);
    }

    private static int executeArgumentHelp(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        ParseResults parseResults = ClientCommandManager.DISPATCHER.parse(StringArgumentType.getString(context, (String)"command"), (Object)((FabricClientCommandSource)context.getSource()));
        List nodes = parseResults.getContext().getNodes();
        if (nodes.isEmpty()) {
            throw HelpCommandAccessor.getFailedException().create();
        }
        return ClientCommandInternals.executeHelp((CommandNode<FabricClientCommandSource>)((ParsedCommandNode)Iterables.getLast((Iterable)nodes)).getNode(), context);
    }

    private static int executeHelp(CommandNode<FabricClientCommandSource> startNode, CommandContext<FabricClientCommandSource> context) {
        Map commands = ClientCommandManager.DISPATCHER.getSmartUsage(startNode, (Object)((FabricClientCommandSource)context.getSource()));
        for (String command : commands.values()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)new class_2585("/" + command));
        }
        return commands.size();
    }

    public static void addCommands(CommandDispatcher<FabricClientCommandSource> target) {
        Object2ObjectOpenHashMap originalToCopy = new Object2ObjectOpenHashMap();
        originalToCopy.put((Object)ClientCommandManager.DISPATCHER.getRoot(), (Object)target.getRoot());
        ClientCommandInternals.copyChildren((CommandNode<FabricClientCommandSource>)ClientCommandManager.DISPATCHER.getRoot(), (CommandNode<FabricClientCommandSource>)target.getRoot(), (Map<CommandNode<FabricClientCommandSource>, CommandNode<FabricClientCommandSource>>)originalToCopy);
    }

    private static void copyChildren(CommandNode<FabricClientCommandSource> origin, CommandNode<FabricClientCommandSource> target, Map<CommandNode<FabricClientCommandSource>, CommandNode<FabricClientCommandSource>> originalToCopy) {
        for (CommandNode child : origin.getChildren()) {
            ArgumentBuilder builder = child.createBuilder();
            if (builder.getRedirect() != null) {
                builder.redirect(originalToCopy.get(builder.getRedirect()));
            }
            CommandNode result = builder.build();
            originalToCopy.put((CommandNode<FabricClientCommandSource>)child, (CommandNode<FabricClientCommandSource>)result);
            target.addChild(result);
            if (child.getChildren().isEmpty()) continue;
            ClientCommandInternals.copyChildren((CommandNode<FabricClientCommandSource>)child, (CommandNode<FabricClientCommandSource>)result, originalToCopy);
        }
    }

    public void registerCommands(CommandDispatcher<QuiltClientCommandSource> dispatcher) {
        if (!ClientCommandManager.DISPATCHER.getRoot().getChildren().isEmpty()) {
            LiteralArgumentBuilder<FabricClientCommandSource> help = ClientCommandManager.literal("help");
            help.executes(ClientCommandInternals::executeRootHelp);
            help.then(ClientCommandManager.argument("command", StringArgumentType.greedyString()).executes(ClientCommandInternals::executeArgumentHelp));
            LiteralCommandNode mainNode = ClientCommandManager.DISPATCHER.register((LiteralArgumentBuilder)ClientCommandManager.literal(API_COMMAND_NAME).then(help));
            ClientCommandManager.DISPATCHER.register((LiteralArgumentBuilder)ClientCommandManager.literal(SHORT_API_COMMAND_NAME).redirect((CommandNode)mainNode));
            ClientCommandInternals.addCommands(dispatcher);
        }
        ClientCommandManager.DISPATCHER.findAmbiguities((parent, child, sibling, inputs) -> LOGGER.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{ClientCommandManager.DISPATCHER.getPath(child), ClientCommandManager.DISPATCHER.getPath(sibling), inputs}));
    }
}

